import pandas as pd
import numpy as np
from scipy import stats 
import pickle
from decision_company import read_csv_file,  join_dataframes, join_dataframes, anova_test

atp_tennis = read_csv_file('atp_tennis.csv')

# Perform statistical tests for each ranking group
anova_results = {}
for group in ['Top-ranked', 'Mid-ranked', 'Low-ranked']:
    group_data = join_dataframes(player_data, unique_player_data[unique_player_data['Rank_Group'] == group][['Player', 'Rank_Group']], on='Player')
    hard_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Hard'].dropna()
    clay_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Clay'].dropna()
    grass_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Grass'].dropna()

    if len(hard_data) > 0 and len(clay_data) > 0 and len(grass_data) > 0:
        anova_result = anova_test(hard_data, clay_data, grass_data)
        anova_results[group] = anova_result.pvalue
    else:
        anova_results[group] = None

print(anova_results)
pickle.dump(anova_results,open("./ref_result/anova_results.pkl","wb"))